package com.ejie.p06b.model;

import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.detailInfo.DetailInfoAngel;


public class SolicitudReclamacion {
	
	//Tipos de actos reclamados
	//Providencia de apremio
	private static final byte TRAMITAGUNE_TIPOACTORECLAMADO_PA = 1;
	//Providencia de apremio
	private static final byte TRAMITAGUNE_TIPOACTORECLAMADO_RRPA = 2;
	//Providencia de apremio
	private static final byte TRAMITAGUNE_TIPOACTORECLAMADO_DE = 3;
	//Providencia de apremio
	private static final byte TRAMITAGUNE_TIPOACTORECLAMADO_RRDE = 4;
	//Providencia de apremio
	private static final byte TRAMITAGUNE_TIPOACTORECLAMADO_O = 5;
	
	
	private int codSolicitud = -1;//Cdigo de solicitud
	private String idSolTramitagune="";  //ID que ha dado Tramitagune a la Solicitud. Servir para comunicarse con Tramitagune-
	
	/*****************************************/
	/***********Datos basicos*****************/
	/*****************************************/
	//Datos del Reclamante
	private String nombreTitular="";
	private String dniCifTitular="";
	private String dniCifRpte="";
	private String nombreRpte="";
	private Integer codReclamante=-1;
	
	private String nombreRclte="";

	private String numExpVE=""; //Nmero de Expediente
	private Integer duplicado=0; //Posible nmero de expediente duplicado. 0: No duplicado; 1: Duplicado; 2: Acumular
	
	//Canal de Notificacion/comunicacion
	private int tipoNotif = -1;//Tipo canal seleccionado (1-Electronico, 2-Postal)
	private String notifPostalProvincia=""; 
	private String notifPostalLocalidad="";
	private String notifPostalMunicipio="";
	private String notifPostalDirecc="";
	private String notifPostalCP="";
	
	//Avisos
	private int tipoAviso = -1;//Tipo aviso seleccionado (1-Correo electrnico, 2-SMS)
	private String avisoValor=""; //Si Tipo aviso seleccionado=1-->direccion de correo electronico.Si Tipo aviso seleccionado=2-->Nmero de telefono.  
	
	//Avisos
	private String idiomaSol=""; //Idioma de notificaciones, comunicaciones y avisos  
	
	/*****************************************/
	/***********acto reclamado ***************/
	/*****************************************/
	
	private int actoReclamado = -1;//Tipo de acto reclamado
	private int conceptoReclamado = -1;//Concepto del acto Reclamado: 1:Multa de Trafico, 2:Otros
	private int admonReclamado = -1;//Admnistracin que apremia el acto Reclamado: 1:Pais Vasco; 2:Otro
	private String codReclamacion=""; //Cdigo de Reclamacin de la tabla Tipos Reclamacin
	private String codDireccion =""; //Cdigo de Direccin de la tabla Direcciones
	private String codDepartamento=""; //Cdigo de Departamento de la tabla Departamentos

	
	//Providencia de Apremio
	private String refCobroPA = "";//Referencia de cobro
	private String subconceptoPA = "";	//Subconcepto
	private String claveLiquidacionPA = "";//Clave de liquidacin
	private String numSancionPA = "";	//Nmero de sancin de trfico
	private String matriculaPA = "";	//Matrcula
	private String subconcetoOtroPA = "";	//Subconcepto Otros
	private String subconcetoOOtroPA = "";//Subconcepto Otro Otros
	private String numExpedientePA = "";	//Nmero de expediente
	private String claveLiquidacionOtroPA = "";	//Clave de liquidacin
	private String conceptoPA = "";	//Concepto
	
	//Recurso de Reposicin contra la Provicencia de Apremio
	private String numExpedienteRRPA = "";//Nmero de expediente
	private String sancionTraficoRRPA = "";//Sancin de trfico
	private String conceptoRRPA = "";	//Concepto
	private String conceptoOtrosRRPA = "";//Concepto otros
	
	//Diligencia de Embargo
	private String refCobroDE = ""; //Referencia de cobro
	private String expedienteDE = "";//Expediente
	
	//Recurso de Reposicin contra la Diligencia de Embargo
	private String numExpedienteRRDE = "";//Nmero de expediente
	private String conceptoRRDE = "";//Concepto
	private String subconceptoRRDE = "";//Subconcepto
	
	
	//Otros
	private String referenciaO = "";	//Referencia

	private String fechaResolucionO = "";//Fecha de resolucion
	
	private String dptoProcedenciaO = "";//Departamento de procedencia
	
	private String organoProcedenciaO = "";//rgano gestor de procedencia

	private String organismoProcedenciaO = "";//rganismo gestor de procedencia
	
	/*****************************************/
	/*********** Alegaciones *****************/
	/*****************************************/

	private String textoAlegaciones = ""; //Texto introducido en la pestaa de Alegaciones
	private int alegPuestaManif=-1; //Alegaciones. Solicita puesta de manifiesto para poder alegar: 0 - sin chequear
	private int alegAnulacion=-1; //Alegaciones. Solicita la anulacin del acto administrativo impugnado:0 - sin chequear
	private String alegTexto="";//Texto de las alegaciones

	//Fecha de Efectos
	private String fechaEfectos = "";//Fecha de Efectos
	
	/**
	 * Constructor por defecto Alegaciones
	 * 
	 * @param datosAlegaciones
	 *            : Objeto de tipo Alegaciones con la informacin de Alegaciones de la peticin en Tramitagune de alta de solicitud de reclamacin
	 */
	public SolicitudReclamacion(DetailInfoAngel.Alegaciones datosAlegaciones) {
		
		this.textoAlegaciones = datosAlegaciones.getGrupotextoalegacionesNo().getAreatextoAlegaciones();
		this.alegPuestaManif=datosAlegaciones.getGrupotextoalegacionesNo().getSolicitoTribunal().getSolicito1().getTextoSolicito1().getElementoTextoSolicito1();
		this.alegAnulacion=datosAlegaciones.getGrupotextoalegacionesNo().getSolicitoTribunal().getSolicito2().getTextosolicito2().getElementoTextosolicito2();
		this.alegTexto=datosAlegaciones.getGrupotextoalegacionesNo().getAreatextoAlegaciones().toString();
		
		
		P06BLog.send(0,this, "(SolicitudReclamacion(Alegaciones)) Objeto con los datos Alegaciones parseados creado correctamente");
		
	}
	
	
	
	/**
	 * Constructor por defecto
	 * 
	 * @param datosNegocio
	 *            : Objeto de tipo PestanaActoReclamado con la informacin de datos de
	 *            negocio de la peticin en Tramitagune de alta de solicitud de reclamacin
	 */
	public SolicitudReclamacion(DetailInfoAngel.PestanaActoReclamado datosNegocio) {
		
		P06BLog.send(0,this, "(SolicitudReclamacion) Creacin del objeto con los datos de negocio parseados");
		
		//Providencia de Apremio
		if(datosNegocio.getTipoActoReclamado().getTipoacto() == SolicitudReclamacion.TRAMITAGUNE_TIPOACTORECLAMADO_PA){
			//Provicencia de Apremio
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado Providencia de Apremio");			
			this.actoReclamado = datosNegocio.getTipoActoReclamado().getTipoacto();
			this.conceptoReclamado = datosNegocio.getGrupoConcepto().getConcepto();
			this.admonReclamado = datosNegocio.getGrupoAdministracion().getAdministracionApremio();
			
			
			//Referencia de cobro
			this.refCobroPA = datosNegocio.getIdentificacionActo1().getIdentificacionActo1MtrGv1();
			//Nmero de sancin de trfico
			if (!datosNegocio.getIdentificacionActo1().getIdentificacionActo1MtrGv2().equals("")){
				this.numSancionPA = datosNegocio.getIdentificacionActo1().getIdentificacionActo1MtrGv2();
				if (this.numSancionPA!=null && !this.numSancionPA.equals("")){
					numExpVE=this.numSancionPA;	
				}
			}
			
			//Subconcepto
			this.subconceptoPA = datosNegocio.getIdentificacionActo1().getIdentificacionActo1MtrGv3();
			
			//Clave de liquidacin
			this.claveLiquidacionPA =  datosNegocio.getIdentificacionActo2().getIdentificacionActo1MtrAeat1();
			//Nmero de sancin de trfico
			if (!datosNegocio.getIdentificacionActo2().getIdentificacionActo1MtrAeat2().equals("")){
				this.numSancionPA = datosNegocio.getIdentificacionActo2().getIdentificacionActo1MtrAeat2();
				if (this.numSancionPA!=null && !this.numSancionPA.equals("")){
					numExpVE=this.numSancionPA;	
				}
			}

			//Matrcula
			this.matriculaPA = datosNegocio.getIdentificacionActo2().getIdentificacionActo1MtrAeat3();
			
			//Subconcepto Otros
			this.subconcetoOtroPA = datosNegocio.getIdentificacionActo3().getIdentificacionActo1OtrosGv2();
			//Subconcepto Otro Otros
			this.subconcetoOOtroPA = datosNegocio.getIdentificacionActo3().getIdentificacionActo1OtrosGv4();
			//Nmero de expediente
			this.numExpedientePA = datosNegocio.getIdentificacionActo3().getIdentificacionActo1OtrosGv3();
			if (this.numExpedientePA!=null && !this.numExpedientePA.equals("")){
				numExpVE=this.numExpedientePA;	
			}
			
			//Clave de liquidacin
			this.claveLiquidacionOtroPA = datosNegocio.getIdentificacionActo4().getIdentificacionActo1OtrosAeat1();
			//Concepto
			this.conceptoPA = datosNegocio.getIdentificacionActo4().getIdentificacionActo1OtrosAeat2();
		}else if(datosNegocio.getTipoActoReclamado().getTipoacto() == SolicitudReclamacion.TRAMITAGUNE_TIPOACTORECLAMADO_RRPA){
			//Recurso de Reposicin contra la Provicencia de Apremio
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado Recurso de Reposicin contra la Provicencia de Apremio");
			this.actoReclamado = datosNegocio.getTipoActoReclamado().getTipoacto();
			this.conceptoReclamado = datosNegocio.getGrupoConcepto().getConcepto();
			this.admonReclamado = datosNegocio.getGrupoAdministracion().getAdministracionApremio();

			//Nmero de expediente
			if (datosNegocio.getIdentificacion2Acto1()!=null){
				if (datosNegocio.getIdentificacion2Acto1().getIdentificacionActo2Mtr()!=null){
					this.numExpedienteRRPA = datosNegocio.getIdentificacion2Acto1().getIdentificacionActo2Mtr();	
				}
				if (datosNegocio.getIdentificacion2Acto1().getIdentificacionActo2Mtr1()!=null){
					//Sancin de trfico
					this.sancionTraficoRRPA = datosNegocio.getIdentificacion2Acto1().getIdentificacionActo2Mtr1();
				}
			}
					
			//Concepto
			this.conceptoRRPA = datosNegocio.getIdentificacion2Acto2().getIdentificacionActo2OtrosList();			
			//Concepto otros
			this.conceptoOtrosRRPA = datosNegocio.getIdentificacion2Acto2().getIdentificacionActo2OtrosOtros();
			if(this.numExpedienteRRPA.equals("") && !this.conceptoRRPA.equals("")){
				this.numExpedienteRRPA = datosNegocio.getIdentificacion2Acto2().getIdentificacionActo2OtrosExp();
			}
			numExpVE=this.numExpedienteRRPA;	

		}else if(datosNegocio.getTipoActoReclamado().getTipoacto() == SolicitudReclamacion.TRAMITAGUNE_TIPOACTORECLAMADO_DE){
			//Diligencia de Embargo
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado Diligencia de Embargo");
			this.actoReclamado = datosNegocio.getTipoActoReclamado().getTipoacto();
			this.conceptoReclamado = datosNegocio.getGrupoConcepto().getConcepto();
			this.admonReclamado = datosNegocio.getGrupoAdministracion().getAdministracionApremio();
			//Referencia de cobro
			this.refCobroDE = datosNegocio.getIdentificacion3Acto3().getIdentificacionActo3MtrOtros1();			
			//Expediente
			this.expedienteDE = datosNegocio.getIdentificacion3Acto3().getIdentificacionActo3MtrOtros2();
			numExpVE=this.expedienteDE;	

		}else if(datosNegocio.getTipoActoReclamado().getTipoacto() == SolicitudReclamacion.TRAMITAGUNE_TIPOACTORECLAMADO_RRDE){
			//Recurso de Reposicin contra la Diligencia de Embargo
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado Recurso de Reposicin contra la Diligencia de Embargo");
			this.actoReclamado = datosNegocio.getTipoActoReclamado().getTipoacto();
			this.conceptoReclamado = datosNegocio.getGrupoConcepto().getConcepto();
			this.admonReclamado = datosNegocio.getGrupoAdministracion().getAdministracionApremio();
			//Nmero de expediente
			this.numExpedienteRRDE = datosNegocio.getIdentificacion4Acto4().getIdentificacionActo4MtrOtros1();
			//numExpVE=this.numExpedienteRRDE;
			//Concepto
			this.conceptoRRDE = datosNegocio.getIdentificacion4Acto4().getIdentificacionActo4MtrOtros2();			
			//Expedientes
			this.subconceptoRRDE = datosNegocio.getIdentificacion4Acto4().getIdentificacionActo4MtrOtros3();
		}else if(datosNegocio.getTipoActoReclamado().getTipoacto() == SolicitudReclamacion.TRAMITAGUNE_TIPOACTORECLAMADO_O){
			//Otros
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado Otros");
			this.actoReclamado = datosNegocio.getTipoActoReclamado().getTipoacto();
			this.conceptoReclamado = datosNegocio.getGrupoConcepto().getConcepto();
			this.admonReclamado = datosNegocio.getGrupoAdministracion().getAdministracionApremio();
			
			//Referencia
			this.referenciaO = datosNegocio.getIdentificacion5Acto5().getGrupoOtro().getIdentificacionActo5MtrOtros1();
			numExpVE=this.referenciaO;
			//Fecha de resolucion
			this.fechaResolucionO = datosNegocio.getIdentificacion5Acto5().getGrupoOtro().getIdentificacionActo5MtrOtros2();			
			//Departamento de procedencia
			if(datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia()!=null && datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros3()!=null && datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros3().getNombreEs()!=null){
				this.dptoProcedenciaO = datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros3().getNombreEs();	
			}
						
			//rgano gestor de procedencia
			if(datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia()!=null
					&& datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros4()!=null
					&& datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros4().getNombreEs()!=null){
				this.organoProcedenciaO = datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros4().getNombreEs();	
			}
			
			//rganismo gestor de procedencia
			if(datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia()!=null
					&& datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros31()!=null
					&& datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros31().getNombreEs()!=null){
				this.organismoProcedenciaO = datosNegocio.getIdentificacion5Acto5().getGrupoProcedencia().getIdentificacionActo5MtrOtros31().getNombreEs();	
			}
			
		}else{
			P06BLog.send(0,this, "(SolicitudReclamacion) Tipo de acto reclamado no vlido: " + datosNegocio.getTipoActoReclamado().getTipoacto());
		}
		
		P06BLog.send(0,this, "(SolicitudReclamacion) Objeto con los datos de negocio parseados creado correctamente");
		
	}

	/**
	 * @return the actoReclamado
	 */
	public int getActoReclamado() {
		return actoReclamado;
	}

	/**
	 * @param actoReclamado the actoReclamado to set
	 */
	public void setActoReclamado(int actoReclamado) {
		this.actoReclamado = actoReclamado;
	}

	/**
	 * @return the claveLiquidacionOtroPA
	 */
	public String getClaveLiquidacionOtroPA() {
		return claveLiquidacionOtroPA;
	}

	/**
	 * @param claveLiquidacionOtroPA the claveLiquidacionOtroPA to set
	 */
	public void setClaveLiquidacionOtroPA(String claveLiquidacionOtroPA) {
		this.claveLiquidacionOtroPA = claveLiquidacionOtroPA;
	}

	/**
	 * @return the claveLiquidacionPA
	 */
	public String getClaveLiquidacionPA() {
		return claveLiquidacionPA;
	}

	/**
	 * @param claveLiquidacionPA the claveLiquidacionPA to set
	 */
	public void setClaveLiquidacionPA(String claveLiquidacionPA) {
		this.claveLiquidacionPA = claveLiquidacionPA;
	}

	/**
	 * @return the codSolicitud
	 */
	public int getCodSolicitud() {
		return codSolicitud;
	}

	/**
	 * @param codSolicitud the codSolicitud to set
	 */
	public void setCodSolicitud(int codSolicitud) {
		this.codSolicitud = codSolicitud;
	}

	/**
	 * @return the conceptoOtrosRRPA
	 */
	public String getConceptoOtrosRRPA() {
		return conceptoOtrosRRPA;
	}

	/**
	 * @param conceptoOtrosRRPA the conceptoOtrosRRPA to set
	 */
	public void setConceptoOtrosRRPA(String conceptoOtrosRRPA) {
		this.conceptoOtrosRRPA = conceptoOtrosRRPA;
	}

	/**
	 * @return the conceptoPA
	 */
	public String getConceptoPA() {
		return conceptoPA;
	}

	/**
	 * @param conceptoPA the conceptoPA to set
	 */
	public void setConceptoPA(String conceptoPA) {
		this.conceptoPA = conceptoPA;
	}

	/**
	 * @return the conceptoRRDE
	 */
	public String getConceptoRRDE() {
		return conceptoRRDE;
	}

	/**
	 * @param conceptoRRDE the conceptoRRDE to set
	 */
	public void setConceptoRRDE(String conceptoRRDE) {
		this.conceptoRRDE = conceptoRRDE;
	}

	/**
	 * @return the conceptoRRPA
	 */
	public String getConceptoRRPA() {
		return conceptoRRPA;
	}

	/**
	 * @param conceptoRRPA the conceptoRRPA to set
	 */
	public void setConceptoRRPA(String conceptoRRPA) {
		this.conceptoRRPA = conceptoRRPA;
	}

	/**
	 * @return the dptoProcedenciaO
	 */
	public String getDptoProcedenciaO() {
		return dptoProcedenciaO;
	}

	/**
	 * @param dptoProcedenciaO the dptoProcedenciaO to set
	 */
	public void setDptoProcedenciaO(String dptoProcedenciaO) {
		this.dptoProcedenciaO = dptoProcedenciaO;
	}

	/**
	 * @return the expedienteDE
	 */
	public String getExpedienteDE() {
		return expedienteDE;
	}

	/**
	 * @param expedienteDE the expedienteDE to set
	 */
	public void setExpedienteDE(String expedienteDE) {
		this.expedienteDE = expedienteDE;
	}

	/**
	 * @return the fechaResolucionO
	 */
	public String getFechaResolucionO() {
		return fechaResolucionO;
	}

	/**
	 * @param fechaResolucionO the fechaResolucionO to set
	 */
	public void setFechaResolucionO(String fechaResolucionO) {
		this.fechaResolucionO = fechaResolucionO;
	}

	/**
	 * @return the matriculaPA
	 */
	public String getMatriculaPA() {
		return matriculaPA;
	}

	/**
	 * @param matriculaPA the matriculaPA to set
	 */
	public void setMatriculaPA(String matriculaPA) {
		this.matriculaPA = matriculaPA;
	}

	/**
	 * @return the numExpedientePA
	 */
	public String getNumExpedientePA() {
		return numExpedientePA;
	}

	/**
	 * @param numExpedientePA the numExpedientePA to set
	 */
	public void setNumExpedientePA(String numExpedientePA) {
		this.numExpedientePA = numExpedientePA;
	}

	/**
	 * @return the numExpedienteRRDE
	 */
	public String getNumExpedienteRRDE() {
		return numExpedienteRRDE;
	}

	/**
	 * @param numExpedienteRRDE the numExpedienteRRDE to set
	 */
	public void setNumExpedienteRRDE(String numExpedienteRRDE) {
		this.numExpedienteRRDE = numExpedienteRRDE;
	}

	/**
	 * @return the numExpedienteRRPA
	 */
	public String getNumExpedienteRRPA() {
		return numExpedienteRRPA;
	}

	/**
	 * @param numExpedienteRRPA the numExpedienteRRPA to set
	 */
	public void setNumExpedienteRRPA(String numExpedienteRRPA) {
		this.numExpedienteRRPA = numExpedienteRRPA;
	}

	/**
	 * @return the numSancionPA
	 */
	public String getNumSancionPA() {
		return numSancionPA;
	}

	/**
	 * @param numSancionPA the numSancionPA to set
	 */
	public void setNumSancionPA(String numSancionPA) {
		this.numSancionPA = numSancionPA;
	}

	/**
	 * @return the organoProcedenciaO
	 */
	public String getOrganoProcedenciaO() {
		return organoProcedenciaO;
	}

	/**
	 * @param organoProcedenciaO the organoProcedenciaO to set
	 */
	public void setOrganoProcedenciaO(String organoProcedenciaO) {
		this.organoProcedenciaO = organoProcedenciaO;
	}

	/**
	 * @return the organismoProcedenciaO
	 */
	public String getOrganismoProcedenciaO() {
		return organismoProcedenciaO;
	}
	/**
	 * @param organismoProcedenciaO the organismoProcedenciaO to set
	 */
	public void setOrganismoProcedenciaO(String organismoProcedenciaO) {
		this.organismoProcedenciaO = organismoProcedenciaO;
	}
	/**
	 * @return the refCobroDE
	 */
	public String getRefCobroDE() {
		return refCobroDE;
	}

	/**
	 * @param refCobroDE the refCobroDE to set
	 */
	public void setRefCobroDE(String refCobroDE) {
		this.refCobroDE = refCobroDE;
	}

	/**
	 * @return the refCobroPA
	 */
	public String getRefCobroPA() {
		return refCobroPA;
	}

	/**
	 * @param refCobroPA the refCobroPA to set
	 */
	public void setRefCobroPA(String refCobroPA) {
		this.refCobroPA = refCobroPA;
	}

	/**
	 * @return the referenciaO
	 */
	public String getReferenciaO() {
		return referenciaO;
	}

	/**
	 * @param referenciaO the referenciaO to set
	 */
	public void setReferenciaO(String referenciaO) {
		this.referenciaO = referenciaO;
	}

	/**
	 * @return the sancionTraficoRRPA
	 */
	public String getSancionTraficoRRPA() {
		return sancionTraficoRRPA;
	}

	/**
	 * @param sancionTraficoRRPA the sancionTraficoRRPA to set
	 */
	public void setSancionTraficoRRPA(String sancionTraficoRRPA) {
		this.sancionTraficoRRPA = sancionTraficoRRPA;
	}

	/**
	 * @return the subconceptoPA
	 */
	public String getSubconceptoPA() {
		return subconceptoPA;
	}

	/**
	 * @param subconceptoPA the subconceptoPA to set
	 */
	public void setSubconceptoPA(String subconceptoPA) {
		this.subconceptoPA = subconceptoPA;
	}

	/**
	 * @return the subconceptoRRDE
	 */
	public String getSubconceptoRRDE() {
		return subconceptoRRDE;
	}

	/**
	 * @param subconceptoRRDE the subconceptoRRDE to set
	 */
	public void setSubconceptoRRDE(String subconceptoRRDE) {
		this.subconceptoRRDE = subconceptoRRDE;
	}

	/**
	 * @return the subconcetoOOtroPA
	 */
	public String getSubconcetoOOtroPA() {
		return subconcetoOOtroPA;
	}

	/**
	 * @param subconcetoOOtroPA the subconcetoOOtroPA to set
	 */
	public void setSubconcetoOOtroPA(String subconcetoOOtroPA) {
		this.subconcetoOOtroPA = subconcetoOOtroPA;
	}

	/**
	 * @return the subconcetoOtroPA
	 */
	public String getSubconcetoOtroPA() {
		return subconcetoOtroPA;
	}

	/**
	 * @param subconcetoOtroPA the subconcetoOtroPA to set
	 */
	public void setSubconcetoOtroPA(String subconcetoOtroPA) {
		this.subconcetoOtroPA = subconcetoOtroPA;
	}

	/**
	 * @return the tRAMITAGUNE_TIPOACTORECLAMADO_DE
	 */
	public static byte getTramitaguneTipoActoReclamadoDE() {
		return TRAMITAGUNE_TIPOACTORECLAMADO_DE;
	}

	/**
	 * @return the tRAMITAGUNE_TIPOACTORECLAMADO_O
	 */
	public static byte getTramitaguneTipoActoReclamadoO() {
		return TRAMITAGUNE_TIPOACTORECLAMADO_O;
	}

	/**
	 * @return the tRAMITAGUNE_TIPOACTORECLAMADO_PA
	 */
	public static byte getTramitaguneTipoActoReclamadoPA() {
		return TRAMITAGUNE_TIPOACTORECLAMADO_PA;
	}

	/**
	 * @return the tRAMITAGUNE_TIPOACTORECLAMADO_RRDE
	 */
	public static byte getTramitaguneTipoActoReclamadoRRDE() {
		return TRAMITAGUNE_TIPOACTORECLAMADO_RRDE;
	}

	/**
	 * @return the tRAMITAGUNE_TIPOACTORECLAMADO_RRPA
	 */
	public static byte getTramitaguneTipoActoReclamadoRRPA() {
		return TRAMITAGUNE_TIPOACTORECLAMADO_RRPA;
	}

	
	/**
	 * @param dniCifTitular the dniCifTitular to set
	 */
	public void setDniCifTitular(String dniCifTitular) {
		this.dniCifTitular = dniCifTitular;
	}

	/**
	 * @return the dniCifTitular
	 */
	public String getDniCifTitular() {
		return dniCifTitular;
	}

	public String getNombreTitular() {
		return nombreTitular;
	}

	public void setTipoNotif(int tipoNotif) {
		this.tipoNotif = tipoNotif;
	}

	public int getTipoNotif() {
		return tipoNotif;
	}

	public void setDniCifRpte(String dniCifRpte) {
		this.dniCifRpte = dniCifRpte;
	}

	public String getDniCifRpte() {
		return dniCifRpte;
	}

	public void setNombreRpte(String nombreRpte) {
		this.nombreRpte = nombreRpte;
	}

	public String getNombreRpte() {
		return nombreRpte;
	}

	public void setNombreTitular(String nombreTitular) {
		this.nombreTitular = nombreTitular;
	}

	public void setNombreRclte(String nombreRclte) {
		this.nombreRclte = nombreRclte;
	}

	public String getNombreRclte() {
		return nombreRclte;
	}

	public void setNotifPostalLocalidad(String notifPostalLocalidad) {
		this.notifPostalLocalidad = notifPostalLocalidad;
	}

	public String getNotifPostalLocalidad() {
		return notifPostalLocalidad;
	}

	public void setNotifPostalMunicipio(String notifPostalMunicipio) {
		this.notifPostalMunicipio = notifPostalMunicipio;
	}

	public String getNotifPostalMunicipio() {
		return notifPostalMunicipio;
	}

	public void setNotifPostalDirecc(String notifPostalDirecc) {
		this.notifPostalDirecc = notifPostalDirecc;
	}

	public String getNotifPostalDirecc() {
		return notifPostalDirecc;
	}

	public void setNotifPostalCP(String notifPostalCP) {
		this.notifPostalCP = notifPostalCP;
	}

	public String getNotifPostalCP() {
		return notifPostalCP;
	}

	public void setNotifPostalProvincia(String notifPostalProvincia) {
		this.notifPostalProvincia = notifPostalProvincia;
	}

	public String getNotifPostalProvincia() {
		return notifPostalProvincia;
	}

	public void setTipoAviso(int tipoAviso) {
		this.tipoAviso = tipoAviso;
	}

	public int getTipoAviso() {
		return tipoAviso;
	}

	public void setAvisoValor(String avisoValor) {
		this.avisoValor = avisoValor;
	}

	public String getAvisoValor() {
		return avisoValor;
	}

	public void setIdiomaSol(String idiomaSol) {
		this.idiomaSol = idiomaSol;
	}

	public String getIdiomaSol() {
		return idiomaSol;
	}

	public void setConceptoReclamado(int conceptoReclamado) {
		this.conceptoReclamado = conceptoReclamado;
	}

	public int getConceptoReclamado() {
		return conceptoReclamado;
	}

	public void setAdmonReclamado(int admonReclamado) {
		this.admonReclamado = admonReclamado;
	}

	public int getAdmonReclamado() {
		return admonReclamado;
	}

	public void setCodReclamacion(String codReclamacion) {
		this.codReclamacion = codReclamacion;
	}

	public String getCodReclamacion() {
		return codReclamacion;
	}

	public void setCodDireccion(String codDireccion) {
		this.codDireccion = codDireccion;
	}

	public String getCodDireccion() {
		return codDireccion;
	}

	public void setCodDepartamento(String codDepartamento) {
		this.codDepartamento = codDepartamento;
	}

	public String getCodDepartamento() {
		return codDepartamento;
	}

	public void setCodReclamante(Integer codReclamante) {
		this.codReclamante = codReclamante;
	}

	public Integer getCodReclamante() {
		return codReclamante;
	}

	public void setNumExpVE(String numExpVE) {
		this.numExpVE = numExpVE;
	}

	public String getNumExpVE() {
		return numExpVE;
	}

	public void setDuplicado(Integer duplicado) {
		this.duplicado = duplicado;
	}

	public Integer getDuplicado() {
		return duplicado;
	}



	public void setTextoAlegaciones(String textoAlegaciones) {
		this.textoAlegaciones = textoAlegaciones;
	}



	public String getTextoAlegaciones() {
		return textoAlegaciones;
	}



	public void setAlegPuestaManif(int alegPuestaManif) {
		this.alegPuestaManif = alegPuestaManif;
	}



	public int getAlegPuestaManif() {
		return alegPuestaManif;
	}



	public void setAlegAnulacion(int alegAnulacion) {
		this.alegAnulacion = alegAnulacion;
	}



	public int getAlegAnulacion() {
		return alegAnulacion;
	}



	public void setAlegTexto(String alegTexto) {
		this.alegTexto = alegTexto;
	}



	public String getAlegTexto() {
		return alegTexto;
	}



	public void setFechaEfectos(String fechaEfectos) {
		this.fechaEfectos = fechaEfectos;
	}



	public String getFechaEfectos() {
		return fechaEfectos;
	}



	/**
	 * @param idSolTramitagune the idSolTramitagune to set
	 */
	public void setIdSolTramitagune(String idSolTramitagune) {
		this.idSolTramitagune = idSolTramitagune;
	}



	/**
	 * @return the idSolTramitagune
	 */
	public String getIdSolTramitagune() {
		return idSolTramitagune;
	}


}
